<?php
namespace ova_framework\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ova_counter_up extends Widget_Base {

	public function __construct($data = [], $args = null) {
      parent::__construct($data, $args);  
   	}

	public function get_name() {
		return 'ova_counter_up';
	}

	public function get_title() {
		return __( 'Ova Counter Up', 'ova-framework' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return [ 'ovatheme' ];
	}

	public function get_script_depends() {
		wp_enqueue_script( 'waypoints', OVA_PLUGIN_URI.'assets/libs/waypoints/jquery.waypoints.min.js');
		wp_enqueue_script( 'counter-up', OVA_PLUGIN_URI.'assets/libs/counter-up/jquery.counterup.js');

		return [ 'script-elementor' ];
	}

	protected function register_controls() {

	//begin section content
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'ova-framework' ),
			]
		);

			$this->add_control(
				'version',
				[
					'label' => __( 'Version', 'ova-framework' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'counter-up-v1',
					'options' => [
						'counter-up-v1' => esc_html__( 'Version 1', 'ova-framework' ),
						'counter-up-v2' => esc_html__( 'Version 2', 'ova-framework' ),
					]
				]
			);

			$repeater = new \Elementor\Repeater();

			$repeater->add_control(
				'class_icon',
				[
					'label' => __( 'Class Icon', 'ova-framework' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => 'icon-donation',
				]
			);


			$repeater->add_control(
				'price',
				[
					'label' => __( 'Price', 'ova-framework' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'rows' => 3,
					'default' => __( 86700, 'ova-framework' )
				]
			);

			$repeater->add_control(
				'text',
				[
					'label' => __( 'text', 'ova-framework' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => __( 'Successfull Campaigns', 'ova-framework' )
				]
			);

			$this->add_control(
				'delay',
				[
					'label' 	=> __( 'Delay', 'ova-framework' ),
					'type' 		=> \Elementor\Controls_Manager::NUMBER,
					'default' 	=> 10,
				]
			);

			$this->add_control(
				'time',
				[
					'label' 	=> __( 'Animation Duration', 'ova-framework' ),
					'type' 		=> \Elementor\Controls_Manager::NUMBER,
					'default' 	=> 1200,
				]
			);

			$this->add_control(
				'tabs_item',
				[
					'label'   => 'Items Counter Up',
					'type'    => Controls_Manager::REPEATER,
					'fields'  => $repeater->get_controls(),
					'default' => [
						[
							'class_icon' => __('icon-donation', 'ova-framework'),
							'price' => __(10000, 'ova-framework'),
							'text' => __('Successfull Campaigns'),
						],
					],
				]
			);

			$this->add_control(
				'currencies',
				[
					'label' 	=> __( 'Currency', 'ova-framework' ),
					'type' 		=> Controls_Manager::SELECT,
					'default' 	=> '',
					'options' 	=> $this->ova_counter_get_currencies(),
				]
			);

			$this->add_control(
				'currency_position',
				[
					'label' 	=> __( 'Currency Position', 'ova-framework' ),
					'type' 		=> Controls_Manager::CHOOSE,
					'default' 	=> 'before',
					'toggle' 	=> false,
					'options' 	=> [
						'before' => [
							'title' => __( 'Before', 'ova-framework' ),
							'icon' => 'eicon-h-align-left',
						],
						'after' => [
							'title' => __( 'After', 'ova-framework' ),
							'icon' => 'eicon-h-align-right',
						],
					],
					'condition' => [
						'currencies!' => '',
					],
				]
			);

			$this->add_control(
				'thousand_separator',
				[
					'label' 	=> __( 'Thousand Separator', 'ova-framework' ),
					'type' 		=> \Elementor\Controls_Manager::SWITCHER,
					'label_on' 	=> __( 'Show', 'ova-framework' ),
					'label_off' => __( 'Hide', 'ova-framework' ),
					'return_value' => 'yes',
					'default' 	=> 'yes',
				]
			);

			$this->add_control(
				'separator',
				[
					'label' 	=> __( 'Separator', 'ova-framework' ),
					'type' 		=> Controls_Manager::SELECT,
					'default' 	=> 'default',
					'options' 	=> [
						'default' 	=> __( 'Default', 'ova-framework' ),
						'dot' 		=> __( 'Dot', 'ova-framework' ),
						'space' 	=> __( 'Space', 'ova-framework' ),
					],
					'condition' => [
						'thousand_separator' => 'yes',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'items_v1_border',
					'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up',
					'separator' => 'before',
					'condition' => [
                        'version[value]' => 'counter-up-v1',
                    ],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'items_v2_border',
					'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up',
					'separator' => 'before',
					'condition' => [
                        'version[value]' => 'counter-up-v2',
                    ],
				]
			);

			$this->add_responsive_control(
				'align_v1',
				[
					'label' => __( 'Alignment', 'ova-framework' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'ova-framework' ),
							'icon' => 'fa fa-align-left',
						],
						'center' => [
							'title' => __( 'Center', 'ova-framework' ),
							'icon' => 'fa fa-align-center',
						],
						'right' => [
							'title' => __( 'Right', 'ova-framework' ),
							'icon' => 'fa fa-align-right',
						],
					],
					'selectors' => [
						'{{WRAPPER}} .counter-up-v1 .ova-counter-up' => 'justify-content: {{VALUE}};',
						'{{WRAPPER}} .counter-up-v2' => 'justify-content: {{VALUE}};',
					],
				]
			);
			

		$this->end_controls_section();
	//end section content

		
	//begin section content style

		//content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => __( 'Content', 'ova-framework' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'content_background',
				[
					'label' => __( 'Backgorund', 'ova-framework' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-counter-up' => 'background-color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'max_width',
				[
					'label' => __( 'Width', 'plugin-domain' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
							'step' => 5,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ova-counter-up' => 'max-width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'content_border_radius',
				[
					'label' => __( 'Border Radius', 'ova-framework' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova-counter-up' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);

			$this->add_control(
				'content_margin',
				[
					'label' => __( 'Margin', 'ova-framework' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova-counter-up' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
					],
				]
			);

			$this->add_control(
				'content_paddding',
				[
					'label' => __( 'Padding', 'ova-framework' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .ova-counter-up' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name' 		=> 'content_box_shadow',
					'label' 	=> __( 'Box Shadow', 'ova-framework' ),
					'selector' 	=> '{{WRAPPER}} .ova-counter-up',
				]
			);

		$this->end_controls_section();


		//icon
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => __( 'Icon', 'ova-framework' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs( 'icon_style' );

		        $this->start_controls_tab(
		            'icon_style_normal',
		            [
		                'label' => __( 'Normal', 'ova_framework' ),
		            ]
		        );

			        $this->add_control(
						'color_icon',
						[
							'label' => __( 'Color', 'ova-framework' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .icon' => 'color : {{VALUE}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .icon span' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'icon_v1_typography',
							'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up .icon',
							'condition' => [
		                            'version[value]' => 'counter-up-v1',
		                    ],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'icon_v2_typography',
							'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up .icon span',
							'condition' => [
		                            'version[value]' => 'counter-up-v2',
		                        ],
						]
					);

					$this->add_control(
						'icon_margin',
						[
							'label' => __( 'Margin', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
						'icon_paddding',
						[
							'label' => __( 'Padding', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

        		$this->end_controls_tab();

			    $this->start_controls_tab(
			            'icon_style_hover',
			            [
			                'label' => __( 'Hover', 'ova_framework' ),
			            ]
			        );
			        $this->add_control(
						'color_icon_hover',
						[
							'label' => __( 'Color', 'ova-framework' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .icon' => 'color : {{VALUE}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .icon span' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'icon_v1_hover_typography',
							'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .icon',
							'condition' => [
		                            'version[value]' => 'counter-up-v1',
		                        ],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'icon_v2_hover_typography',
							'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .icon span',
							'condition' => [
		                            'version[value]' => 'counter-up-v2',
		                        ],
						]
					);

					$this->add_control(
						'icon_margin_hover',
						[
							'label' => __( 'Margin', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
						'icon_paddding_hover',
						[
							'label' => __( 'Padding', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);


		        $this->end_controls_tab();

    		$this->end_controls_tabs();

		$this->end_controls_section();


		//price
		$this->start_controls_section(
			'section_price_style',
			[
				'label' => __( 'Price', 'ova-framework' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs( 'price_style' );

		        $this->start_controls_tab(
		            'price_style_normal',
		            [
		                'label' => __( 'Normal', 'ova_framework' ),
		            ]
		        );

			        $this->add_control(
						'color_price',
						[
							'label' => __( 'Color', 'ova-framework' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4' => 'color : {{VALUE}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'price_v1_typography',
							'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4',
							'condition' => [
		                            'version[value]' => 'counter-up-v1',
		                    ],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'price_v2_typography',
							'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4',
							'condition' => [
		                            'version[value]' => 'counter-up-v2',
		                        ],
						]
					);

					$this->add_control(
						'price_margin',
						[
							'label' => __( 'Margin', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
						'price_paddding',
						[
							'label' => __( 'Padding', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

		        $this->end_controls_tab();

			    $this->start_controls_tab(
		            'price_style_hover',
		            [
		                'label' => __( 'Hover', 'ova_framework' ),
		            ]
		        );

			        $this->add_control(
						'color_price_hover',
						[
							'label' => __( 'Color', 'ova-framework' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content h4' => 'color : {{VALUE}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .price h4' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'price_v1_hover_typography',
							'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content h4',
							'condition' => [
		                            'version[value]' => 'counter-up-v1',
		                        ],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'price_v2_hover_typography',
							'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .price h4',
							'condition' => [
		                            'version[value]' => 'counter-up-v2',
		                        ],
						]
					);

					$this->add_control(
						'price_margin_hover',
						[
							'label' => __( 'Margin', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .price h4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
						'price_paddding:hover',
						[
							'label' => __( 'Padding', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .price h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

	        	$this->end_controls_tab();

        	$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section_currency_style',
			[
				'label' 	=> __( 'Currency', 'ova-framework' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'currencies!' => '',
				],
			]
		);

			$this->add_control(
				'color_currency',
				[
					'label' => __( 'Color', 'ova-framework' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4 .currency-symbol' 	=> 'color : {{VALUE}};',
						'{{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4 .currency-symbol' 	=> 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'currency_typography',
					'selector' 	=> '{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4 .currency-symbol, {{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4 .currency-symbol',
				]
			);

			$this->add_control(
				'currency_margin',
				[
					'label' => __( 'Margin', 'ova-framework' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors' => [
						'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content h4 .currency-symbol' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .counter-up-v2 .ova-counter-up .price h4 .currency-symbol' 	=> 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section();

		//text
		$this->start_controls_section(
			'section_text_style',
			[
				'label' => __( 'Text', 'ova-framework' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

			$this->start_controls_tabs( 'text_style' );

		        $this->start_controls_tab(
		            'text_style_normal',
		            [
		                'label' => __( 'Normal', 'ova_framework' ),
		            ]
		        );

			        $this->add_control(
						'color_text',
						[
							'label' => __( 'Color', 'ova-framework' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content .text' => 'color : {{VALUE}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .text p' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'text_v1_typography',
							'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up .content .text',
							'condition' => [
		                            'version[value]' => 'counter-up-v1',
		                    ],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'text_v2_typography',
							'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up .text p',
							'condition' => [
		                            'version[value]' => 'counter-up-v2',
		                        ],
						]
					);

					$this->add_control(
						'text_margin',
						[
							'label' => __( 'Margin', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
						'text_paddding',
						[
							'label' => __( 'Padding', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up .content .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

		        $this->end_controls_tab();

			    $this->start_controls_tab(
		            'text_style_hover',
			            [
			                'label' => __( 'Hover', 'ova_framework' ),
			            ]
		        	);
			    
			        $this->add_control(
						'color_text_hover',
						[
							'label' => __( 'Color', 'ova-framework' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content .text' => 'color : {{VALUE}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .text p' => 'color : {{VALUE}};',
							],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'text_v1_hover_typography',
							'selector' => '{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content .text',
							'condition' => [
		                            'version[value]' => 'counter-up-v1',
		                        ],
						]
					);

					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'text_v2_hover_typography',
							'selector' => '{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .text p',
							'condition' => [
		                            'version[value]' => 'counter-up-v2',
		                        ],
						]
					);

					$this->add_control(
						'text_margin_hover',
						[
							'label' => __( 'Margin', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .text p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

					$this->add_control(
						'price_paddding_hover',
						[
							'label' => __( 'Padding', 'ova-framework' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', 'em', '%' ],
							'selectors' => [
								'{{WRAPPER}} .counter-up-v1 .ova-counter-up:hover .content .text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .counter-up-v2 .ova-counter-up:hover .text p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);

	        	$this->end_controls_tab();

        	$this->end_controls_tabs();

		$this->end_controls_section();


	//end section content style
		
	}

	//render
	protected function render() {
		$settings 	= $this->get_settings_for_display();
		$version 	= $settings['version'];
		$tabs_item 	= $settings['tabs_item'];
		$delay  	= $settings['delay'] ? $settings['delay']: 10;
		$time  		= $settings['time'] ? $settings['time']: 1200;

		$currency 			= $settings['currencies'];
		$symbols 			= $this->ova_get_currency_symbols();
		$currency_symbol 	= isset( $symbols[ $currency ] ) ? $symbols[ $currency ] : '';
		$currency_position  = $settings['currency_position'];
		$separator 			= $settings['separator'];

		?>

		<?php if ( !empty($tabs_item) ) : ?>

			<?php if ( 'counter-up-v1' === $version ) : ?>
				<div class="counter-up-v1">
					<?php foreach ($tabs_item as $items) : ?>
						<div class="ova-counter-up">

							<?php if( isset( $items['class_icon'] ) ){ ?>
								<div class="icon">
									<span class="<?php echo esc_html( $items['class_icon'] ); ?>"></span>
								</div>
							<?php } ?>

							<div class="content">
								<?php if( isset( $items['price'] ) ){ ?>
									<h4 class="title-counter">
										<?php if ( $currency_symbol && 'before' == $currency_position ): ?>
											<span class="currency-symbol"><?php printf( $currency_symbol ); ?></span>
										<?php endif; ?>
										<span class="counter" 
											  data-num="<?php echo esc_attr( number_format( $items['price'] ) ); ?>" 
											  data-delay="<?php echo esc_attr( $delay ); ?>" 
											  data-time="<?php echo esc_attr( $time ); ?>" 
											  data-separator="<?php echo esc_attr( $separator ); ?>">0
										</span>
										<?php if ( $currency_symbol && 'after' == $currency_position ): ?>
											<span class="currency-symbol"><?php printf( $currency_symbol ); ?></span>
										<?php endif; ?>
									</h4>
								<?php } ?>

								<?php if( isset( $items['text'] ) ){ ?>
									<p class="text"><?php echo esc_html( $items['text'] ); ?></p>
								<?php } ?>

							</div>
						</div>
					<?php endforeach; ?>
				</div>

			<?php else: ?>
				<div class="counter-up-v2">
					<?php foreach ($tabs_item as $items) : ?>
						<div class="ova-counter-up">
							<?php if( isset( $items['class_icon'] ) ){ ?>
							<div class="icon">
								<span class="<?php echo esc_html( $items['class_icon'] ); ?>"></span>
							</div>
							<?php } ?>

							<?php if( isset( $items['price'] ) ){ ?>
							<div class="price">
								<h4 class="title-counter">
									<?php if ( $currency_symbol && 'before' == $currency_position ): ?>
										<span class="currency-symbol"><?php printf( $currency_symbol ); ?></span>
									<?php endif; ?>
									<span class="counter" 
										  data-num="<?php echo esc_attr( number_format( $items['price'] ) ); ?>" 
										  data-delay="<?php echo esc_attr( $delay ); ?>" 
										  data-time="<?php echo esc_attr( $time ); ?>" 
										  data-separator="<?php echo esc_attr( $separator ); ?>">0
									</span>
									<?php if ( $currency_symbol && 'after' == $currency_position ): ?>
										<span class="currency-symbol"><?php printf( $currency_symbol ); ?></span>
									<?php endif; ?>
								</h4>
							</div>
							<?php } ?>

							<?php if( isset( $items['text'] ) ){ ?>
								<div class="text thrid_font">
									<p><?php echo esc_html( $items['text'] ); ?></p>
								</div>
							<?php } ?>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>

		<?php
		endif;
	}

	protected function ova_counter_get_currencies() {
		$currencies = array_unique(
			apply_filters(
				'ova_counter_up_currencies',
				array(
					''	  => __( 'None', 'ova-framework' ),
					'AED' => __( 'United Arab Emirates dirham', 'ova-framework' ),
					'AFN' => __( 'Afghan afghani', 'ova-framework' ),
					'ALL' => __( 'Albanian lek', 'ova-framework' ),
					'AMD' => __( 'Armenian dram', 'ova-framework' ),
					'ANG' => __( 'Netherlands Antillean guilder', 'ova-framework' ),
					'AOA' => __( 'Angolan kwanza', 'ova-framework' ),
					'ARS' => __( 'Argentine peso', 'ova-framework' ),
					'AUD' => __( 'Australian dollar', 'ova-framework' ),
					'AWG' => __( 'Aruban florin', 'ova-framework' ),
					'AZN' => __( 'Azerbaijani manat', 'ova-framework' ),
					'BAM' => __( 'Bosnia and Herzegovina convertible mark', 'ova-framework' ),
					'BBD' => __( 'Barbadian dollar', 'ova-framework' ),
					'BDT' => __( 'Bangladeshi taka', 'ova-framework' ),
					'BGN' => __( 'Bulgarian lev', 'ova-framework' ),
					'BHD' => __( 'Bahraini dinar', 'ova-framework' ),
					'BIF' => __( 'Burundian franc', 'ova-framework' ),
					'BMD' => __( 'Bermudian dollar', 'ova-framework' ),
					'BND' => __( 'Brunei dollar', 'ova-framework' ),
					'BOB' => __( 'Bolivian boliviano', 'ova-framework' ),
					'BRL' => __( 'Brazilian real', 'ova-framework' ),
					'BSD' => __( 'Bahamian dollar', 'ova-framework' ),
					'BTC' => __( 'Bitcoin', 'ova-framework' ),
					'BTN' => __( 'Bhutanese ngultrum', 'ova-framework' ),
					'BWP' => __( 'Botswana pula', 'ova-framework' ),
					'BYR' => __( 'Belarusian ruble (old)', 'ova-framework' ),
					'BYN' => __( 'Belarusian ruble', 'ova-framework' ),
					'BZD' => __( 'Belize dollar', 'ova-framework' ),
					'CAD' => __( 'Canadian dollar', 'ova-framework' ),
					'CDF' => __( 'Congolese franc', 'ova-framework' ),
					'CHF' => __( 'Swiss franc', 'ova-framework' ),
					'CLP' => __( 'Chilean peso', 'ova-framework' ),
					'CNY' => __( 'Chinese yuan', 'ova-framework' ),
					'COP' => __( 'Colombian peso', 'ova-framework' ),
					'CRC' => __( 'Costa Rican col&oacute;n', 'ova-framework' ),
					'CUC' => __( 'Cuban convertible peso', 'ova-framework' ),
					'CUP' => __( 'Cuban peso', 'ova-framework' ),
					'CVE' => __( 'Cape Verdean escudo', 'ova-framework' ),
					'CZK' => __( 'Czech koruna', 'ova-framework' ),
					'DJF' => __( 'Djiboutian franc', 'ova-framework' ),
					'DKK' => __( 'Danish krone', 'ova-framework' ),
					'DOP' => __( 'Dominican peso', 'ova-framework' ),
					'DZD' => __( 'Algerian dinar', 'ova-framework' ),
					'EGP' => __( 'Egyptian pound', 'ova-framework' ),
					'ERN' => __( 'Eritrean nakfa', 'ova-framework' ),
					'ETB' => __( 'Ethiopian birr', 'ova-framework' ),
					'EUR' => __( 'Euro', 'ova-framework' ),
					'FJD' => __( 'Fijian dollar', 'ova-framework' ),
					'FKP' => __( 'Falkland Islands pound', 'ova-framework' ),
					'GBP' => __( 'Pound sterling', 'ova-framework' ),
					'GEL' => __( 'Georgian lari', 'ova-framework' ),
					'GGP' => __( 'Guernsey pound', 'ova-framework' ),
					'GHS' => __( 'Ghana cedi', 'ova-framework' ),
					'GIP' => __( 'Gibraltar pound', 'ova-framework' ),
					'GMD' => __( 'Gambian dalasi', 'ova-framework' ),
					'GNF' => __( 'Guinean franc', 'ova-framework' ),
					'GTQ' => __( 'Guatemalan quetzal', 'ova-framework' ),
					'GYD' => __( 'Guyanese dollar', 'ova-framework' ),
					'HKD' => __( 'Hong Kong dollar', 'ova-framework' ),
					'HNL' => __( 'Honduran lempira', 'ova-framework' ),
					'HRK' => __( 'Croatian kuna', 'ova-framework' ),
					'HTG' => __( 'Haitian gourde', 'ova-framework' ),
					'HUF' => __( 'Hungarian forint', 'ova-framework' ),
					'IDR' => __( 'Indonesian rupiah', 'ova-framework' ),
					'ILS' => __( 'Israeli new shekel', 'ova-framework' ),
					'IMP' => __( 'Manx pound', 'ova-framework' ),
					'INR' => __( 'Indian rupee', 'ova-framework' ),
					'IQD' => __( 'Iraqi dinar', 'ova-framework' ),
					'IRR' => __( 'Iranian rial', 'ova-framework' ),
					'IRT' => __( 'Iranian toman', 'ova-framework' ),
					'ISK' => __( 'Icelandic kr&oacute;na', 'ova-framework' ),
					'JEP' => __( 'Jersey pound', 'ova-framework' ),
					'JMD' => __( 'Jamaican dollar', 'ova-framework' ),
					'JOD' => __( 'Jordanian dinar', 'ova-framework' ),
					'JPY' => __( 'Japanese yen', 'ova-framework' ),
					'KES' => __( 'Kenyan shilling', 'ova-framework' ),
					'KGS' => __( 'Kyrgyzstani som', 'ova-framework' ),
					'KHR' => __( 'Cambodian riel', 'ova-framework' ),
					'KMF' => __( 'Comorian franc', 'ova-framework' ),
					'KPW' => __( 'North Korean won', 'ova-framework' ),
					'KRW' => __( 'South Korean won', 'ova-framework' ),
					'KWD' => __( 'Kuwaiti dinar', 'ova-framework' ),
					'KYD' => __( 'Cayman Islands dollar', 'ova-framework' ),
					'KZT' => __( 'Kazakhstani tenge', 'ova-framework' ),
					'LAK' => __( 'Lao kip', 'ova-framework' ),
					'LBP' => __( 'Lebanese pound', 'ova-framework' ),
					'LKR' => __( 'Sri Lankan rupee', 'ova-framework' ),
					'LRD' => __( 'Liberian dollar', 'ova-framework' ),
					'LSL' => __( 'Lesotho loti', 'ova-framework' ),
					'LYD' => __( 'Libyan dinar', 'ova-framework' ),
					'MAD' => __( 'Moroccan dirham', 'ova-framework' ),
					'MDL' => __( 'Moldovan leu', 'ova-framework' ),
					'MGA' => __( 'Malagasy ariary', 'ova-framework' ),
					'MKD' => __( 'Macedonian denar', 'ova-framework' ),
					'MMK' => __( 'Burmese kyat', 'ova-framework' ),
					'MNT' => __( 'Mongolian t&ouml;gr&ouml;g', 'ova-framework' ),
					'MOP' => __( 'Macanese pataca', 'ova-framework' ),
					'MRU' => __( 'Mauritanian ouguiya', 'ova-framework' ),
					'MUR' => __( 'Mauritian rupee', 'ova-framework' ),
					'MVR' => __( 'Maldivian rufiyaa', 'ova-framework' ),
					'MWK' => __( 'Malawian kwacha', 'ova-framework' ),
					'MXN' => __( 'Mexican peso', 'ova-framework' ),
					'MYR' => __( 'Malaysian ringgit', 'ova-framework' ),
					'MZN' => __( 'Mozambican metical', 'ova-framework' ),
					'NAD' => __( 'Namibian dollar', 'ova-framework' ),
					'NGN' => __( 'Nigerian naira', 'ova-framework' ),
					'NIO' => __( 'Nicaraguan c&oacute;rdoba', 'ova-framework' ),
					'NOK' => __( 'Norwegian krone', 'ova-framework' ),
					'NPR' => __( 'Nepalese rupee', 'ova-framework' ),
					'NZD' => __( 'New Zealand dollar', 'ova-framework' ),
					'OMR' => __( 'Omani rial', 'ova-framework' ),
					'PAB' => __( 'Panamanian balboa', 'ova-framework' ),
					'PEN' => __( 'Sol', 'ova-framework' ),
					'PGK' => __( 'Papua New Guinean kina', 'ova-framework' ),
					'PHP' => __( 'Philippine peso', 'ova-framework' ),
					'PKR' => __( 'Pakistani rupee', 'ova-framework' ),
					'PLN' => __( 'Polish z&#x142;oty', 'ova-framework' ),
					'PRB' => __( 'Transnistrian ruble', 'ova-framework' ),
					'PYG' => __( 'Paraguayan guaran&iacute;', 'ova-framework' ),
					'QAR' => __( 'Qatari riyal', 'ova-framework' ),
					'RON' => __( 'Romanian leu', 'ova-framework' ),
					'RSD' => __( 'Serbian dinar', 'ova-framework' ),
					'RUB' => __( 'Russian ruble', 'ova-framework' ),
					'RWF' => __( 'Rwandan franc', 'ova-framework' ),
					'SAR' => __( 'Saudi riyal', 'ova-framework' ),
					'SBD' => __( 'Solomon Islands dollar', 'ova-framework' ),
					'SCR' => __( 'Seychellois rupee', 'ova-framework' ),
					'SDG' => __( 'Sudanese pound', 'ova-framework' ),
					'SEK' => __( 'Swedish krona', 'ova-framework' ),
					'SGD' => __( 'Singapore dollar', 'ova-framework' ),
					'SHP' => __( 'Saint Helena pound', 'ova-framework' ),
					'SLL' => __( 'Sierra Leonean leone', 'ova-framework' ),
					'SOS' => __( 'Somali shilling', 'ova-framework' ),
					'SRD' => __( 'Surinamese dollar', 'ova-framework' ),
					'SSP' => __( 'South Sudanese pound', 'ova-framework' ),
					'STN' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'ova-framework' ),
					'SYP' => __( 'Syrian pound', 'ova-framework' ),
					'SZL' => __( 'Swazi lilangeni', 'ova-framework' ),
					'THB' => __( 'Thai baht', 'ova-framework' ),
					'TJS' => __( 'Tajikistani somoni', 'ova-framework' ),
					'TMT' => __( 'Turkmenistan manat', 'ova-framework' ),
					'TND' => __( 'Tunisian dinar', 'ova-framework' ),
					'TOP' => __( 'Tongan pa&#x2bb;anga', 'ova-framework' ),
					'TRY' => __( 'Turkish lira', 'ova-framework' ),
					'TTD' => __( 'Trinidad and Tobago dollar', 'ova-framework' ),
					'TWD' => __( 'New Taiwan dollar', 'ova-framework' ),
					'TZS' => __( 'Tanzanian shilling', 'ova-framework' ),
					'UAH' => __( 'Ukrainian hryvnia', 'ova-framework' ),
					'UGX' => __( 'Ugandan shilling', 'ova-framework' ),
					'USD' => __( 'United States (US) dollar', 'ova-framework' ),
					'UYU' => __( 'Uruguayan peso', 'ova-framework' ),
					'UZS' => __( 'Uzbekistani som', 'ova-framework' ),
					'VEF' => __( 'Venezuelan bol&iacute;var', 'ova-framework' ),
					'VES' => __( 'Bol&iacute;var soberano', 'ova-framework' ),
					'VND' => __( 'Vietnamese &#x111;&#x1ed3;ng', 'ova-framework' ),
					'VUV' => __( 'Vanuatu vatu', 'ova-framework' ),
					'WST' => __( 'Samoan t&#x101;l&#x101;', 'ova-framework' ),
					'XAF' => __( 'Central African CFA franc', 'ova-framework' ),
					'XCD' => __( 'East Caribbean dollar', 'ova-framework' ),
					'XOF' => __( 'West African CFA franc', 'ova-framework' ),
					'XPF' => __( 'CFP franc', 'ova-framework' ),
					'YER' => __( 'Yemeni rial', 'ova-framework' ),
					'ZAR' => __( 'South African rand', 'ova-framework' ),
					'ZMW' => __( 'Zambian kwacha', 'ova-framework' ),
				)
			)
		);

		return $currencies;
	}

	protected function ova_get_currency_symbols() {

		$symbols = apply_filters(
			'ova_counter_up_currency_symbols',
			array(
				'AED' => '&#x62f;.&#x625;',
				'AFN' => '&#x60b;',
				'ALL' => 'L',
				'AMD' => 'AMD',
				'ANG' => '&fnof;',
				'AOA' => 'Kz',
				'ARS' => '&#36;',
				'AUD' => '&#36;',
				'AWG' => 'Afl.',
				'AZN' => 'AZN',
				'BAM' => 'KM',
				'BBD' => '&#36;',
				'BDT' => '&#2547;&nbsp;',
				'BGN' => '&#1083;&#1074;.',
				'BHD' => '.&#x62f;.&#x628;',
				'BIF' => 'Fr',
				'BMD' => '&#36;',
				'BND' => '&#36;',
				'BOB' => 'Bs.',
				'BRL' => '&#82;&#36;',
				'BSD' => '&#36;',
				'BTC' => '&#3647;',
				'BTN' => 'Nu.',
				'BWP' => 'P',
				'BYR' => 'Br',
				'BYN' => 'Br',
				'BZD' => '&#36;',
				'CAD' => '&#36;',
				'CDF' => 'Fr',
				'CHF' => '&#67;&#72;&#70;',
				'CLP' => '&#36;',
				'CNY' => '&yen;',
				'COP' => '&#36;',
				'CRC' => '&#x20a1;',
				'CUC' => '&#36;',
				'CUP' => '&#36;',
				'CVE' => '&#36;',
				'CZK' => '&#75;&#269;',
				'DJF' => 'Fr',
				'DKK' => 'DKK',
				'DOP' => 'RD&#36;',
				'DZD' => '&#x62f;.&#x62c;',
				'EGP' => 'EGP',
				'ERN' => 'Nfk',
				'ETB' => 'Br',
				'EUR' => '&euro;',
				'FJD' => '&#36;',
				'FKP' => '&pound;',
				'GBP' => '&pound;',
				'GEL' => '&#x20be;',
				'GGP' => '&pound;',
				'GHS' => '&#x20b5;',
				'GIP' => '&pound;',
				'GMD' => 'D',
				'GNF' => 'Fr',
				'GTQ' => 'Q',
				'GYD' => '&#36;',
				'HKD' => '&#36;',
				'HNL' => 'L',
				'HRK' => 'kn',
				'HTG' => 'G',
				'HUF' => '&#70;&#116;',
				'IDR' => 'Rp',
				'ILS' => '&#8362;',
				'IMP' => '&pound;',
				'INR' => '&#8377;',
				'IQD' => '&#x639;.&#x62f;',
				'IRR' => '&#xfdfc;',
				'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
				'ISK' => 'kr.',
				'JEP' => '&pound;',
				'JMD' => '&#36;',
				'JOD' => '&#x62f;.&#x627;',
				'JPY' => '&yen;',
				'KES' => 'KSh',
				'KGS' => '&#x441;&#x43e;&#x43c;',
				'KHR' => '&#x17db;',
				'KMF' => 'Fr',
				'KPW' => '&#x20a9;',
				'KRW' => '&#8361;',
				'KWD' => '&#x62f;.&#x643;',
				'KYD' => '&#36;',
				'KZT' => '&#8376;',
				'LAK' => '&#8365;',
				'LBP' => '&#x644;.&#x644;',
				'LKR' => '&#xdbb;&#xdd4;',
				'LRD' => '&#36;',
				'LSL' => 'L',
				'LYD' => '&#x644;.&#x62f;',
				'MAD' => '&#x62f;.&#x645;.',
				'MDL' => 'MDL',
				'MGA' => 'Ar',
				'MKD' => '&#x434;&#x435;&#x43d;',
				'MMK' => 'Ks',
				'MNT' => '&#x20ae;',
				'MOP' => 'P',
				'MRU' => 'UM',
				'MUR' => '&#x20a8;',
				'MVR' => '.&#x783;',
				'MWK' => 'MK',
				'MXN' => '&#36;',
				'MYR' => '&#82;&#77;',
				'MZN' => 'MT',
				'NAD' => 'N&#36;',
				'NGN' => '&#8358;',
				'NIO' => 'C&#36;',
				'NOK' => '&#107;&#114;',
				'NPR' => '&#8360;',
				'NZD' => '&#36;',
				'OMR' => '&#x631;.&#x639;.',
				'PAB' => 'B/.',
				'PEN' => 'S/',
				'PGK' => 'K',
				'PHP' => '&#8369;',
				'PKR' => '&#8360;',
				'PLN' => '&#122;&#322;',
				'PRB' => '&#x440;.',
				'PYG' => '&#8370;',
				'QAR' => '&#x631;.&#x642;',
				'RMB' => '&yen;',
				'RON' => 'lei',
				'RSD' => '&#1088;&#1089;&#1076;',
				'RUB' => '&#8381;',
				'RWF' => 'Fr',
				'SAR' => '&#x631;.&#x633;',
				'SBD' => '&#36;',
				'SCR' => '&#x20a8;',
				'SDG' => '&#x62c;.&#x633;.',
				'SEK' => '&#107;&#114;',
				'SGD' => '&#36;',
				'SHP' => '&pound;',
				'SLL' => 'Le',
				'SOS' => 'Sh',
				'SRD' => '&#36;',
				'SSP' => '&pound;',
				'STN' => 'Db',
				'SYP' => '&#x644;.&#x633;',
				'SZL' => 'L',
				'THB' => '&#3647;',
				'TJS' => '&#x405;&#x41c;',
				'TMT' => 'm',
				'TND' => '&#x62f;.&#x62a;',
				'TOP' => 'T&#36;',
				'TRY' => '&#8378;',
				'TTD' => '&#36;',
				'TWD' => '&#78;&#84;&#36;',
				'TZS' => 'Sh',
				'UAH' => '&#8372;',
				'UGX' => 'UGX',
				'USD' => '&#36;',
				'UYU' => '&#36;',
				'UZS' => 'UZS',
				'VEF' => 'Bs F',
				'VES' => 'Bs.S',
				'VND' => '&#8363;',
				'VUV' => 'Vt',
				'WST' => 'T',
				'XAF' => 'CFA',
				'XCD' => '&#36;',
				'XOF' => 'CFA',
				'XPF' => 'Fr',
				'YER' => '&#xfdfc;',
				'ZAR' => '&#82;',
				'ZMW' => 'ZK',
			)
		);

		return $symbols;
	}
}